/*:
@target MV MZ
@plugindesc スキルツリーコンフィグ v1.0.1
@author うなぎおおとろ
@url https://raw.githubusercontent.com/unagiootoro/RPGMZ/master/SkillTreeConfig.js

@help
[概要]
スキルツリーを導入するプラグインです。
SPを使ってスキルを習得するスキルツリーを作成することができます。

[使用方法]
■ スキルツリーの設定
スキルツリーの設定は、「SkillTreeConfig.js」ファイルを編集することで行います。
基本的な設定としては、アクターごとにスキルツリーのタイプ(剣スキルや魔法スキルなど)を設定し、
そしてタイプごとにスキルツリーを構築します。
スキルツリーの構築は、スキルの派生設定(ファイアⅠを取得したらファイアⅡが取得可能になるなど)によって行います。

■ SPの入手設定
スキルの習得には、SPが必要となります。
SPの入手方法としては
・戦闘終了による獲得
・レベルアップによるSP獲得
の二通りの設定を行うことができます。

・戦闘終了時に得られるSPの設定方法
敵キャラのメモ欄に
<battleEndGainSp: SP>
の形式で記載します。

・レベルアップによるSP獲得方法の設定
コンフィグの「levelUpGainSp」によって設定を行います。

■ イベントでSPを獲得する方法
スクリプトで
skt_gainSp(アクターID, 獲得するSP値)
と記載することで、該当のアクターが指定したSPを獲得することができます。
例えば、アクターIDが1のアクターが5SPを獲得する場合、
skt_gainSp(1, 5);
と記載します。

■ 割り振った累計SPの取得
skt_totalSp(アクターID, 累計SP格納先変数ID)
と記載することで、該当のアクターが今までに割り振ったSPを指定した変数に代入することができます。
例えば、アクターIDが1のアクターの累計SPをID2の変数に代入する場合、
skt_totalSp(1, 2);
と記載します。

■ スキルリセット
スクリプトで
skt_skillReset(アクターID);
と記載することで、一度習得したスキルをリセットすることができます。
例えば、アクターIDが1のアクターのスキルリセットを行う場合、
skt_skillReset(1);
と記載します。

■ スキルツリータイプの有効/無効
スクリプトで
skt_enableType(アクターID, "タイプ名");
と記載することで、タイプを有効にします。

無効にする場合は、
skt_disableType(アクターID, "タイプ名")
と記載します。

無効にしたタイプは、スキルツリーのタイプ一覧には表示されません。

■ タイプの引継ぎ
特定の条件を満たすとスキルツリーに新たなスキルが追加されるようにしたい場合、「タイプの引継ぎ」を使用します。
例えば、タイプ「下位魔法」を「上位魔法」に変更したい場合、あらかじめ両方のタイプをコンフィグに登録した上で、
「上位魔法」は無効化しておきます。そして、タイプの引継ぎ機能を用いて、「下位魔法」を「上位魔法」に引き継がせます。

タイプの引継ぎを行う場合、スクリプトで
skt_migrationType(アクターID, "引継ぎ元タイプ名", "引継ぎ先タイプ名", リセット有無);
と記載します。リセット有無については、引継ぎ後、引継ぎ元のタイプのスキルツリーをリセットする場合、trueを、
リセットしない場合、falseを指定します。
例えば、アクターIDが1のアクターが、タイプ「下位魔法」を「上位魔法」に引き継がせ、さらにスキルリセットを行う場合、
skt_migrationType(アクターID, "下位魔法", "上位魔法", true);
と記載します。

■ マップからスキルツリーを読み込む
マップからスキルツリーの各スキルの配置座標を読み込むことで、ある程度自由なレイアウトのスキルツリーを
作成することができます。この機能によって設定可能なのはスキルの座標のみであり、スキル間の線はプラグイン側で描画します。

・スキル座標の設定
マップ上のイベントにて、設定を行います。
例えば、"ファイア"というスキルがある場合、スキルを配置したい座標に空のイベントを作成し、
イベントのメモ欄に
ファイア
と記載します。すると、"ファイア"とメモ欄に記載したイベントのXY座標がスキルのXY座標として使用されます。

■ スクリプトからスキルツリーを起動
スクリプトで
skt_open(アクターID);
と記載することで、指定したアクターのスキルツリーを起動することができます。

■ スクリプトからスキルツリーのスキルを取得する
スクリプトで
skt_learn(アクターID, "タイプ名", スキル名, 強制取得有無(省略可));
と記載することで、指定したスキルを取得することができます。
スキル名は「skillTreeInfo」で指定したものを使用してください。
強制取得有無にtrueを設定した場合、習得可能か否かの判定を無視して強制的にスキルを取得します。
また、この場合SPは消費されません。
強制取得有無にfalseを設定した場合は通常通りの方法でスキルを取得します。この場合はSPも消費されます。
なおこの項目については省略可能です。省略した場合はfalseが適用されます。
例: アクターID1のキャラクターで、タイプ「剣技」のスキルツリーの「強撃」を取得する場合
skt_learn(1, "剣技", "強撃", false);
*/

const loadSkillTreeConfig = () => {
return {
// =============================================================
// ●ここからは設定項目です。
// =============================================================

// スキルツリーのタイプの設定を行います。
// skillTreeTypes: [ ～ ]の中にアクターの数だけタイプ設定を追加します。

// タイプ設定は、次の形式で設定します。
// { actorId: アクターのID, types: [タイプ情報1, タイプ情報2, ...] }

// タイプ情報は、次の形式で設定します。
// [タイプ種別, タイプ名, タイプの説明, タイプ有効/無効]
// タイプ種別...スキルの派生設定でタイプを識別するためのユニークな識別子を設定します。
// タイプ名...タイプ一覧のウィンドウに表示するタイプ名を設定します。
// タイプの説明...タイプ一覧のウィンドウに表示するタイプの説明を設定します。
// タイプ有効/無効...タイプを有効にする場合は、trueを、無効にする場合は、falseを指定します。
//                  この項目については、省略可能です。省略した場合、trueが指定されます。
skillTreeTypes: [
    {
        actorId: 1,
          types: [
            ["鬼魔闘術", "鬼魔闘術", "鬼魔闘術を取得します。", true, 80],
            ["下級鬼導呪術", "鬼導呪術", "鬼導呪術を取得します。", true, 81],
            ["中級鬼導呪術", "鬼導呪術", "鬼導呪術を取得します。", false, 81],
            ["上級鬼導呪術", "鬼導呪術", "鬼導呪術を取得します。", false, 81],
            ["龍級鬼導呪術", "鬼導呪術", "鬼導呪術を取得します。", false, 81],
            ["エルパッシブスキル", "エルパッシブスキル", "エルパッシブスキルを取得します。", true, 82],

        ]

    },

    {
        actorId: 2,
          types: [
            ["魔導銃術", "魔導銃術", "魔導銃術を取得します。", true, 83],
            ["我流回復術", "我流回復術", "我流回復術を取得します。", true, 84],
            ["リディシアパッシブスキル", "リディシアパッシブスキル", "リディシアパッシブスキルを取得します。", true, 85],
            ["共通パッシブスキル", "共通パッシブスキル", "共通パッシブスキルを取得します。", true, 79],
        ]

    },


    {
        actorId: 4,
        types: [
            ["剣技", "剣技", "剣技を取得します。", true, 76],
            ["格闘技", "格闘技", "格闘技を取得します。", true, 77],
        ]
    },

    {
        actorId: 5,
        types: [
            ["下位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", true, 79],
            ["上位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", false, 79],
            ["回復魔法", "回復魔法", "回復魔法を取得します。", true, 72],
        ]
    },

    {
        actorId: 6,
        types: [
            ["下位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", true, 79],
            ["上位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", false, 79],
            ["回復魔法", "回復魔法", "回復魔法を取得します。", true, 72],
        ]
    },

    {
        actorId: 7,
        types: [
            ["下位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", true, 79],
            ["上位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", false, 79],
            ["回復魔法", "回復魔法", "回復魔法を取得します。", true, 72],
        ]
    },

    {
        actorId: 8,
        types: [
            ["下位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", true, 79],
            ["上位攻撃魔法", "攻撃魔法", "攻撃魔法を取得します。", false, 79],
            ["回復魔法", "回復魔法", "回復魔法を取得します。", true, 72],
        ]
    },
],

// スキルツリーのマップ読み込み設定を行います。
// 読み込むマップは以下の形式で指定します。
// skillTreeMapId: { skillTreeName1: mapID1, skillTreeName2: mapID2, ... }
// skillTreeName...スキルツリーのタイプ名を指定します。
// mapID...読み込むマップIDを指定します。0の場合は読み込みを行いません。
skillTreeMapId: {
    "下位攻撃魔法": 2,
    "上位攻撃魔法": 2,
    "回復魔法": 3,
    "剣技": 4,
    "格闘技": 5,
},

// 各スキルの情報を登録します。
// skillTreeInfo: [ ～ ]の中に登録するスキル数分のスキル情報の登録を行います。

// スキル情報の登録は次の形式で行います。
// [スキル名, スキルID, 必要SP, アイコン情報]
// スキル名...スキルツリーの派生設定でスキルを一意に識別するための識別子
//            識別子なので、実際のスキル名と一致していなくても問題はありません。
// スキルID...データベース上で該当するスキルのID
// 必要SP...スキルの習得に必要なSP
// アイコン情報については、アイコンを使用するか、任意の画像を使用するかに応じて次の形式で登録します。
//   アイコンを使用する場合 ["icon", iconIndex]
//   iconIndex...使用するアイコンのインデックス
//               iconIndexは省略可能です。省略した場合、スキルに設定されているアイコンが使用されます。
//   画像を使用する場合 ["img", fileName]
//   fileName...画像のファイル名。画像は、「img/pictures」フォルダにインポートしてください。
// なお、アイコン情報については省略可能です。省略した場合、["icon"]が適用されます。
skillTreeInfo: [
    // 鬼魔闘術
    ["練魔一式", 53, 100, ["img", "back-blue"]],
    ["練魔二式", 54, 500, ["img", "back-blue"]],
    ["練魔三式", 55, 2000, ["img", "back-blue"]],
  
    ["練魔・赤龍", 56, 8000, ["img", "back-blue"]],
    ["我流癒掌術", 57, 50, ["img", "back-blue"]],
    ["零式・鬼正拳", 58, 75, ["img", "back-blue"]],
    ["零式・回転脚", 59, 120, ["img", "back-blue"]],
    ["零式・連ね", 60, 150, ["img", "back-blue"]],
    ["一式・鬼魔拳", 61, 230, ["img", "back-blue"]],
    ["一式・魔旋風", 62, 300, ["img", "back-blue"]],
    ["一式・解連撃", 63, 340, ["img", "back-blue"]],
    ["二式・鬼魔破拳", 64, 650, ["img", "back-blue"]],
    ["二式・魔刃旋風", 65, 800, ["img", "back-blue"]],
  ["二式・練解連撃", 66, 750, ["img", "back-blue"]],
    ["三式・鬼魔真破拳", 67,2300 , ["img", "back-blue"]],
    ["三式・魔刃連旋風", 68, 3500, ["img", "back-blue"]],
    ["三式・練解功連撃", 69, 3000, ["img", "back-blue"]],
 ["赤龍拳", 70, 9999, ["img", "back-blue"]],
    ["赤龍旋風脚", 71, 9999, ["img", "back-blue"]],
    ["赤龍蹂躙撃", 72, 9999, ["img", "back-blue"]],




    // 鬼導呪術
    ["赤の癒し", 74, 150, ["img", "back-blue"]],
    ["鬼式呪術・撃", 75, 200, ["img", "back-blue"]],
    ["鬼式呪術・沼", 76, 300, ["img", "back-blue"]],
    ["鬼式呪術・砕", 77, 190, ["img", "back-blue"]],
    ["赤の力", 78, 250, ["img", "back-blue"]],
    ["鬼式呪術・牙", 79, 700, ["img", "back-blue"]],
    ["鬼式呪術・泥沼", 80, 900, ["img", "back-blue"]],
    ["鬼式呪術・乱砕", 81, 780, ["img", "back-blue"]],
    ["赤の鱗", 82, 500, ["img", "back-blue"]],
    ["赤の安らぎ", 83, 1000, ["img", "back-blue"]],
    ["鬼式呪術・鋭牙", 84, 2500, ["img", "back-blue"]],
    ["鬼式呪術・脚引", 85, 3000, ["img", "back-blue"]],
    ["鬼式呪術・鎧砕", 86, 2300, ["img", "back-blue"]],
    ["赤の風", 87, 4500, ["img", "back-blue"]],
    ["鬼式呪術・鬼牙絶唱", 88, 5500, ["img", "back-blue"]],
    ["鬼式呪術・英霊脚引", 89, 4000, ["img", "back-blue"]],
    ["鬼式呪術・皆砕全乱", 90, 6500, ["img", "back-blue"]],
    ["赤龍鱗", 91, 4000, ["img", "back-blue"]],
    ["赤龍剛力", 92, 9999, ["img", "back-blue"]],
    ["赤龍の慈悲", 93, 9999, ["img", "back-blue"]],
    ["赤龍ノ牙", 94, 9999, ["img", "back-blue"]],
// エルパッシブスキル
    ["初気練り", 96, 600, ["img", "back-blue"]],
    ["弐気練り", 97, 2900, ["img", "back-blue"]],
    ["参気練り", 98, 5000, ["img", "back-blue"]],
    ["龍気練り", 99, 9999, ["img", "back-blue"]],
    ["しっかりストレッチ", 100, 100, ["img", "back-blue"]],
    ["ばっちりストレッチ", 101, 500, ["img", "back-blue"]],
    ["しなっとストレッチ", 102, 2000, ["img", "back-blue"]],
    ["かんぺきストレッチ", 103, 8000, ["img", "back-blue"]],
    ["よく見る", 104, 50, ["img", "back-blue"]],
    ["じいっとよく見る", 105, 350, ["img", "back-blue"]],
    ["すごくよく見る", 106, 900, ["img", "back-blue"]],
    ["まじまじと見る", 107, 3000, ["img", "back-blue"]],
    ["赤角赤瞳1", 108, 500, ["img", "back-blue"]],
    ["赤角赤瞳2", 109, 1000, ["img", "back-blue"]],
    ["赤角赤瞳3", 110, 3000, ["img", "back-blue"]],
    ["赤角赤瞳4", 111, 6000, ["img", "back-blue"]],
    ["赤角赤瞳5", 112, 9999, ["img", "back-blue"]],
    ["天賦の魔才1", 113, 500, ["img", "back-blue"]],
    ["天賦の魔才2", 114, 1000, ["img", "back-blue"]],
    ["天賦の魔才3", 115, 3000, ["img", "back-blue"]],
    ["天賦の魔才4", 116, 5000, ["img", "back-blue"]],
    ["天賦の魔才5", 117, 8000, ["img", "back-blue"]],


 // ラミル式ガジェット
    ["マジックボム", 122, 1, ["img", "back-blue"]],
    ["ガジガジくん", 123, 1, ["img", "back-blue"]],
    ["バッドフレイムV1", 124, 1, ["img", "back-blue"]],
  
    ["アイスカーテンs1", 125, 1, ["img", "back-blue"]],
    ["なんかすごいの（5番）", 126, 1, ["img", "back-blue"]],
    ["マギサンダーボム", 127, 2, ["img", "back-blue"]],
    ["マギステルガン", 128, 1, ["img", "back-blue"]],
    ["ネイチャークラック", 129, 2, ["img", "back-blue"]],
    ["エレメンタルカーテン", 130, 2, ["img", "back-blue"]],
    ["いろいろやったの（19番）", 131, 1, ["img", "back-blue"]],
    ["マギライトボム", 132, 3, ["img", "back-blue"]],
    ["エレメンタルフォグ", 133, 3, ["img", "back-blue"]],
    ["クロックアップ", 134, 2, ["img", "back-blue"]],
  ["ハイネスガード", 135, 3, ["img", "back-blue"]],
    ["ラミルキャノン", 136, 3, ["img", "back-blue"]],
    ["リバースチェイン", 137, 2, ["img", "back-blue"]],
    ["マギカグレイト", 138, 3, ["img", "back-blue"]],
 ["ソルジャーｓパワー", 139, 3, ["img", "back-blue"]],
    ["ラミルちゃんボム", 140, 3, ["img", "back-blue"]],
    ["グレートクロック", 141, 3, ["img", "back-blue"]],




    // ラミル式魔導機術
    ["set・スピードアウト", 143, 1, ["img", "back-blue"]],
    ["set・ディフェンスアウト", 144, 1, ["img", "back-blue"]],
    ["set・アタックアウト", 145, 1, ["img", "back-blue"]],
    ["set・スピードブーストALL", 146, 1, ["img", "back-blue"]],
    ["set・パワーブーストALL", 147, 1, ["img", "back-blue"]],
    ["set・マギカブーストALL", 148, 1, ["img", "back-blue"]],
    ["set・タフネスブーストALL", 149, 1, ["img", "back-blue"]],
    ["set・スピードブースト", 150, 1, ["img", "back-blue"]],
    ["set・パワーブースト", 151, 1, ["img", "back-blue"]],
    ["set・マギカブースト", 152, 1, ["img", "back-blue"]],
    ["set・タフネスブースト", 153, 1, ["img", "back-blue"]],
    ["アナライズver1", 154, 1, ["img", "back-blue"]],
    ["アナライズver2", 155, 2, ["img", "back-blue"]],
    ["アナライズver3", 156, 3, ["img", "back-blue"]],
    ["set・フルブーストALL", 157, 3, ["img", "back-blue"]],
    ["set・オールアウトALL", 158, 3, ["img", "back-blue"]],
    ["set・フルブースト", 159, 3, ["img", "back-blue"]],
    ["set・オールアウト", 160, 3, ["img", "back-blue"]],
    ["アナライズver4", 161, 4, ["img", "back-blue"]],
    ["set・オールマイティ", 162, 4, ["img", "back-blue"]],

// ラミルパッシブスキル
    ["天賦の魔導技巧1", 164, 1, ["img", "back-blue"]],
    ["天賦の魔導技巧2", 165, 1, ["img", "back-blue"]],
    ["天賦の魔導技巧3", 166, 2, ["img", "back-blue"]],
    ["天賦の魔導技巧4", 167, 2, ["img", "back-blue"]],
    ["天賦の魔導技巧5", 168, 3, ["img", "back-blue"]],
    ["超開発術:お薬", 169, 1, ["img", "back-blue"]],
    ["超開発術:警戒", 170, 1, ["img", "back-blue"]],
    ["超開発術:先制", 171, 1, ["img", "back-blue"]],
    ["超開発術:お金", 172, 2, ["img", "back-blue"]],
    ["超開発術:収集", 173, 2, ["img", "back-blue"]],
    ["魔導相殺1", 174, 1, ["img", "back-blue"]],
    ["魔導相殺2", 175, 1, ["img", "back-blue"]],
    ["魔導相殺3", 176, 2, ["img", "back-blue"]],
    ["魔導相殺4", 177, 2, ["img", "back-blue"]],
    ["魔導相殺5", 178, 3, ["img", "back-blue"]],
    ["ハイチューニング1", 179, 1, ["img", "back-blue"]],
    ["ハイチューニング2", 180, 1, ["img", "back-blue"]],
    ["ハイチューニング3", 181, 2, ["img", "back-blue"]],
    ["ハイチューニング4", 182, 2, ["img", "back-blue"]],
    ["ハイチューニング5", 183, 3, ["img", "back-blue"]],
    ["超効率操作1", 184, 1, ["img", "back-blue"]],
    ["超効率操作2", 185, 1, ["img", "back-blue"]],
    ["超効率操作3", 186, 2, ["img", "back-blue"]],
    ["超効率操作4", 187, 2, ["img", "back-blue"]],
    ["超効率操作5", 188, 3, ["img", "back-blue"]],

 // 魔導銃術
    ["マジックバレット", 211, 1, ["img", "back-blue"]],
    ["スタンバレット", 212, 1, ["img", "back-blue"]],
    ["フレイムバレット", 213, 1, ["img", "back-blue"]],
  
    ["アイスバレット", 214, 1, ["img", "back-blue"]],
    ["サンダーバレット", 215, 1, ["img", "back-blue"]],
    ["アースバレット", 216, 1, ["img", "back-blue"]],
    ["ウインドバレット", 217, 1, ["img", "back-blue"]],
    ["ウォーターバレット", 218, 1, ["img", "back-blue"]],
    ["マギスライド", 219, 2, ["img", "back-blue"]],
    ["トリプルスタン", 220, 2, ["img", "back-blue"]],
    ["セットポジション", 221, 2, ["img", "back-blue"]],
    ["マギカレイルバレット", 222, 2, ["img", "back-blue"]],
    ["ブレイズショット", 223, 3, ["img", "back-blue"]],
  ["フリージングダブル", 224, 3, ["img", "back-blue"]],
    ["ライジングゼロ", 225, 3, ["img", "back-blue"]],
    ["クエイクブレイク", 226, 3, ["img", "back-blue"]],
    ["タイフーン", 227, 3, ["img", "back-blue"]],
 ["ヴォルテクス", 228, 3, ["img", "back-blue"]],
    ["ダークワン", 229, 4, ["img", "back-blue"]],
    ["シャイニングゼロ", 230, 4, ["img", "back-blue"]],




    // 我流回復術
    ["ヒーリングソング", 190, 1, ["img", "back-blue"]],
    ["マギヒール", 191, 1, ["img", "back-blue"]],
    ["チアフルソング", 192, 1, ["img", "back-blue"]],
    ["プリベンション", 193, 1, ["img", "back-blue"]],
    ["キュアーララバイ", 194, 1, ["img", "back-blue"]],
    ["マギヒーリング", 195, 1, ["img", "back-blue"]],
    ["マギカブロック", 196, 3, ["img", "back-blue"]],
    ["パワーシルト", 197, 3, ["img", "back-blue"]],
    ["クリア", 198, 1, ["img", "back-blue"]],
    ["クリアヒール", 199, 2, ["img", "back-blue"]],
    ["スタンドアップ", 200, 2, ["img", "back-blue"]],
    ["フルマギカヒール", 201, 2, ["img", "back-blue"]],
    ["チアー＆キュアー", 202, 2, ["img", "back-blue"]],
    ["プリベンションエア", 203, 3, ["img", "back-blue"]],
    ["マギカシルトエア", 204, 3, ["img", "back-blue"]],
    ["パワーシルトエア", 205, 3, ["img", "back-blue"]],
    ["クリアレイン", 206, 2, ["img", "back-blue"]],
    ["ホーリーララバイ", 207, 3, ["img", "back-blue"]],
    ["セントシルトエア", 208, 5, ["img", "back-blue"]],
    ["セイクリッドキュアー", 209, 3, ["img", "back-blue"]],

// リディシアパッシブスキル
    ["癒しの魔力1", 232, 1, ["img", "back-blue"]],
    ["癒しの魔力2", 233, 1, ["img", "back-blue"]],
    ["癒しの魔力3", 234, 2, ["img", "back-blue"]],
    ["癒しの魔力4", 235, 2, ["img", "back-blue"]],
    ["癒しの魔力5", 236, 3, ["img", "back-blue"]],
    ["清めの力1", 237, 1, ["img", "back-blue"]],
    ["清めの力2", 238, 1, ["img", "back-blue"]],
    ["清めの力3", 239, 1, ["img", "back-blue"]],
    ["清めの力4", 240, 1, ["img", "back-blue"]],
    ["清めの力5", 241, 1, ["img", "back-blue"]],
    ["護身専念1", 242, 1, ["img", "back-blue"]],
    ["護身専念2", 243, 1, ["img", "back-blue"]],
    ["護身専念3", 244, 2, ["img", "back-blue"]],
    ["護身専念4", 245, 2, ["img", "back-blue"]],
    ["護身専念5", 246, 3, ["img", "back-blue"]],
    ["守護の纏い1", 247, 1, ["img", "back-blue"]],
    ["守護の纏い2", 248, 1, ["img", "back-blue"]],
    ["守護の纏い3", 249, 2, ["img", "back-blue"]],
    ["守護の纏い4", 250, 2, ["img", "back-blue"]],
    ["守護の纏い5", 251, 3, ["img", "back-blue"]],
    ["揺るがずの肉体1", 252, 1, ["img", "back-blue"]],
    ["揺るがずの肉体2", 253, 1, ["img", "back-blue"]],
    ["揺るがずの肉体3", 254, 1, ["img", "back-blue"]],
    ["揺るがずの肉体4", 255, 1, ["img", "back-blue"]],
    ["揺るがずの肉体5", 256, 1, ["img", "back-blue"]],

     // 共通パッシブスキル
    ["HPアップ1", 257, 1, ["img", "back-blue"]],
    ["HPアップ2", 258, 1, ["img", "back-blue"]],
    ["HPアップ3", 259, 2, ["img", "back-blue"]],
    ["HPアップ4", 260, 2, ["img", "back-blue"]],
    ["HPアップ5", 261, 3, ["img", "back-blue"]],
    ["MPアップ1", 262, 1, ["img", "back-blue"]],
    ["MPアップ2", 263, 1, ["img", "back-blue"]],
    ["MPアップ3", 264, 2, ["img", "back-blue"]],
    ["MPアップ4", 265, 2, ["img", "back-blue"]],
    ["MPアップ5", 266, 3, ["img", "back-blue"]],
    ["攻撃力アップ1", 267, 1, ["img", "back-blue"]],
    ["攻撃力アップ2", 268, 1, ["img", "back-blue"]],
    ["攻撃力アップ3", 269, 2, ["img", "back-blue"]],
    ["攻撃力アップ4", 270, 2, ["img", "back-blue"]],
    ["攻撃力アップ5", 271, 3, ["img", "back-blue"]],
    ["防御力アップ1", 272, 1, ["img", "back-blue"]],
    ["防御力アップ2", 273, 1, ["img", "back-blue"]],
    ["防御力アップ3", 274, 2, ["img", "back-blue"]],
    ["防御力アップ4", 275, 2, ["img", "back-blue"]],
    ["防御力アップ5", 276, 3, ["img", "back-blue"]],
    ["魔法攻撃アップ1", 277, 1, ["img", "back-blue"]],
    ["魔法攻撃アップ2", 278, 1, ["img", "back-blue"]],
    ["魔法攻撃アップ3", 279, 2, ["img", "back-blue"]],
    ["魔法攻撃アップ4", 280, 2, ["img", "back-blue"]],
    ["魔法攻撃アップ5", 281, 3, ["img", "back-blue"]],
    ["魔法防御アップ1", 282, 1, ["img", "back-blue"]],
    ["魔法防御アップ2", 283, 1, ["img", "back-blue"]],
    ["魔法防御アップ3", 284, 2, ["img", "back-blue"]],
    ["魔法防御アップ4", 285, 2, ["img", "back-blue"]],
    ["魔法防御アップ5", 286, 3, ["img", "back-blue"]],
    ["敏捷アップ1", 287, 1, ["img", "back-blue"]],
    ["敏捷アップ2", 288, 1, ["img", "back-blue"]],
    ["敏捷アップ3", 289, 2, ["img", "back-blue"]],
    ["敏捷アップ4", 290, 2, ["img", "back-blue"]],
    ["敏捷アップ5", 291, 3, ["img", "back-blue"]],
    ["運アップ1", 292, 1, ["img", "back-blue"]],
    ["運アップ2", 293, 1, ["img", "back-blue"]],
    ["運アップ3", 294, 2, ["img", "back-blue"]],
    ["運アップ4", 295, 2, ["img", "back-blue"]],
    ["運アップ5", 296, 3, ["img", "back-blue"]],

    // 攻撃魔法
    ["ファイアⅠ", 99, 1, ["img", "back-red"]],
    ["ファイアⅡ", 100, 1, ["img", "back-red"]],
    ["ファイアⅢ", 101, 1, ["img", "back-red"]],

    ["フレイムⅠ", 103, 1, ["img", "back-red"]],
    ["フレイムⅡ", 104, 1, ["img", "back-red"]],
    ["フレイムⅢ", 105, 1, ["img", "back-red"]],

    ["アイスⅠ", 107, 1, ["img", "back-blue"]],
    ["アイスⅡ", 108, 1, ["img", "back-blue"]],
    ["アイスⅢ", 109, 1, ["img", "back-blue"]],

    ["ブリザードⅠ", 111, 1, ["img", "back-blue"]],
    ["ブリザードⅡ", 112, 1, ["img", "back-blue"]],
    ["ブリザードⅢ", 113, 1, ["img", "back-blue"]],

    ["サンダーⅠ", 115, 1, ["img", "back-yellow"]],
    ["サンダーⅡ", 116, 1, ["img", "back-yellow"]],
    ["サンダーⅢ", 117, 1, ["imgx", "back-yellow"]],

    ["スパークⅠ", 119, 1, ["img", "back-yellow"]],
    ["スパークⅡ", 120, 1, ["img", "back-yellow"]],
    ["スパークⅢ", 121, 1, ["img", "back-yellow"]],

    ["ニュークリアⅠ", 156, 1, ["img", "back-gray"]],
    ["ニュークリアⅡ", 157, 1, ["img", "back-gray"]],

    // 回復魔法
    ["ヒールⅠ", 52, 1, ["img", "back-green"]],
    ["ヒールⅡ", 53, 1, ["img", "back-green"]],
    ["ヒールⅢ", 54, 1, ["img", "back-green"]],

    ["リカバーⅠ", 56, 1, ["img", "back-green"]],
    ["リカバーⅡ", 57, 1, ["img", "back-green"]],
    ["リカバーⅢ", 58, 1, ["img", "back-green"]],

    ["キュアーⅠ", 60, 1, ["img", "back-green"]],
    ["キュアーⅡ", 61, 1, ["img", "back-green"]],
    ["キュアーⅢ", 62, 1, ["img", "back-green"]],

    ["レイズⅠ", 64, 1, ["img", "back-green"]],
    ["レイズⅡ", 65, 1, ["img", "back-green"]],
],

// スキルツリーの派生設定を行います。
// skillTreeDerivative: { ～ }の中にタイプ数分のスキルツリーの登録を行います。

// スキルツリーの派生設定は次のように行います。
// "タイプ名": [ [スキル1, [派生先スキル1, 派生先スキル2, ...]], [スキル2, [派生先スキル3, 派生先スキル4, ...] ]
// ※派生先スキルが存在しない終端スキルの場合、派生先スキルは省略可能です。
//
// 例えば、"様子を見る"と"連続攻撃"を取得すると、"２回攻撃"が取得できるようにするには、次の設定を行います。
// ["様子を見る", ["２回攻撃"]],
// ["連続攻撃", ["２回攻撃"]],
// ["２回攻撃"],
//
// また、"ヒール"を取得すると、"ファイア"と"スパーク"が取得できるようにするには、次の設定を行います。
// ["ヒール", ["ファイア"]],
// ["ヒール", ["スパーク"]],
// ["ファイア"],
// ["スパーク"],
skillTreeDerivative: {
   "鬼魔闘術": [
  ["練魔一式", ["練魔二式","一式・鬼魔拳","一式・魔旋風","一式・解連撃"]],
	["練魔二式", ["練魔三式","二式・鬼魔破拳","二式・魔刃旋風","二式・練解連撃"]],
        ["練魔三式", ["練魔・赤龍","三式・鬼魔真破拳","三式・魔刃連旋風","三式・練解功連撃"]],
        ["練魔・赤龍", ["赤龍拳","赤龍旋風脚","赤龍蹂躙撃"]],
	["我流癒掌術"],
        ["零式・鬼正拳", ["一式・鬼魔拳"]],
        ["零式・回転脚", ["一式・魔旋風"]],
	["零式・連ね", ["一式・解連撃"]],
        ["一式・鬼魔拳", ["二式・鬼魔破拳"]],
        ["一式・魔旋風", ["二式・魔刃旋風"]],
	["一式・解連撃", ["二式・練解連撃"]],
        ["二式・鬼魔破拳", ["三式・鬼魔真破拳"]],
        ["二式・魔刃旋風", ["三式・魔刃連旋風"]],
	["二式・練解連撃", ["三式・練解功連撃"]],
        ["三式・鬼魔真破拳", ["赤龍拳"]],
 ["三式・魔刃連旋風", ["赤龍旋風脚"]],
	["三式・練解功連撃", ["赤龍蹂躙撃"]],
        ["赤龍拳"],
 ["赤龍旋風脚"],
 ["赤龍蹂躙撃"],
    ],

    "下級鬼導呪術": [
        ["赤の癒し"],
        ["鬼式呪術・撃"],
        ["鬼式呪術・沼"],
        ["鬼式呪術・砕"],
        ["赤の力"],

    ],
    "中級鬼導呪術": [
        ["赤の癒し", ["赤の安らぎ"]],
        ["鬼式呪術・撃", ["鬼式呪術・牙"]],
        ["鬼式呪術・沼", ["鬼式呪術・泥沼"]],
        ["鬼式呪術・砕", ["鬼式呪術・乱砕"]],
        ["赤の力", ["赤の鱗"]],
	["赤の安らぎ"],
        ["鬼式呪術・牙"],
        ["鬼式呪術・泥沼"],
        ["鬼式呪術・乱砕"],
        ["赤の鱗"],

    ],
    "上級鬼導呪術": [
        ["赤の癒し", ["赤の安らぎ"]],
        ["鬼式呪術・撃", ["鬼式呪術・牙"]],
        ["鬼式呪術・沼", ["鬼式呪術・泥沼"]],
        ["鬼式呪術・砕", ["鬼式呪術・乱砕"]],
        ["赤の力", ["赤の鱗"]],
	["赤の安らぎ", ["赤の風"]],
        ["鬼式呪術・牙", ["鬼式呪術・鋭牙"]],
        ["鬼式呪術・泥沼", ["鬼式呪術・脚引"]],
        ["鬼式呪術・乱砕", ["鬼式呪術・鎧砕"]],
        ["赤の鱗"],
        ["赤の風"],
        ["鬼式呪術・鋭牙"],
        ["鬼式呪術・脚引"],
        ["鬼式呪術・鎧砕"],

    ],
   "龍級鬼導呪術": [
        ["赤の癒し", ["赤の安らぎ"]],
        ["鬼式呪術・撃", ["鬼式呪術・牙"]],
        ["鬼式呪術・沼", ["鬼式呪術・泥沼"]],
        ["鬼式呪術・砕", ["鬼式呪術・乱砕"]],
        ["赤の力", ["赤の鱗"]],
	["赤の安らぎ", ["赤の風"]],
        ["鬼式呪術・牙", ["鬼式呪術・鋭牙"]],
        ["鬼式呪術・泥沼", ["鬼式呪術・脚引"]],
        ["鬼式呪術・乱砕", ["鬼式呪術・鎧砕"]],
        ["赤の鱗", ["赤龍鱗","赤龍剛力"]],
        ["赤の風", ["赤龍の慈悲"]],
        ["鬼式呪術・鋭牙", ["赤龍ノ牙"]],
        ["鬼式呪術・脚引", ["赤龍ノ牙"]],
        ["鬼式呪術・鎧砕", ["赤龍ノ牙"]],
        ["赤龍鱗"],
        ["赤龍剛力"],
        ["赤龍の慈悲"],
        ["赤龍ノ牙"],

    ],

 "ラミル式ガジェット": [
        ["マジックボム", ["バッドフレイムV1","アイスカーテンs1"]],
        ["ガジガジくん", ["なんかすごいの（5番）"]],
        ["バッドフレイムV1", ["なんかすごいの（5番）"]],
        ["アイスカーテンs1", ["なんかすごいの（5番）"]],
        ["なんかすごいの（5番）", ["マギサンダーボム"]],

	["マギサンダーボム", ["マギステルガン","ネイチャークラック","エレメンタルカーテン"]],
        ["マギステルガン", ["いろいろやったの（19番）"]],
        ["ネイチャークラック", ["いろいろやったの（19番）"]],
        ["エレメンタルカーテン", ["いろいろやったの（19番）"]],
        ["いろいろやったの（19番）", ["マギライトボム"]],

        ["マギライトボム", ["エレメンタルフォグ","クロックアップ","ハイネスガード","ラミルキャノン"]],
        ["エレメンタルフォグ", ["マギカグレイト","ソルジャーｓパワー"]],
        ["クロックアップ", ["リバースチェイン"]],
        ["ハイネスガード", ["マギカグレイト","ソルジャーｓパワー"]],
        ["ラミルキャノン", ["ラミルちゃんボム"]],

        ["リバースチェイン", ["グレートクロック"]],
        ["マギカグレイト", ["グレートクロック"]],
        ["ソルジャーｓパワー", ["グレートクロック"]],
        ["ラミルちゃんボム", ["グレートクロック"]],
        ["グレートクロック"],
    ],

 "ラミル式魔導機術": [
        ["set・スピードアウト", ["set・マギカブーストALL","set・パワーブーストALL","set・タフネスブーストALL","set・パワーブースト","set・マギカブースト","set・タフネスブースト"]],
        ["set・ディフェンスアウト", ["set・スピードアウト"]],
        ["set・アタックアウト", ["set・スピードアウト"]],
        ["set・スピードブーストALL", ["set・フルブーストALL","set・オールアウトALL"]],
        ["set・パワーブーストALL", ["set・スピードブーストALL"]],

	["set・マギカブーストALL", ["set・スピードブーストALL"]],
        ["set・タフネスブーストALL", ["set・スピードブーストALL"]],
        ["set・スピードブースト", ["set・フルブースト","set・オールアウト"]],
        ["set・パワーブースト", ["set・スピードブースト"]],
        ["set・マギカブースト", ["set・スピードブースト"]],

        ["set・タフネスブースト", ["set・スピードブースト"]],
        ["アナライズver1", ["アナライズver2"]],
        ["アナライズver2", ["アナライズver3"]],
        ["アナライズver3", ["アナライズver4"]],
        ["set・フルブーストALL", ["set・オールマイティ"]],

        ["set・オールアウトALL",["set・オールマイティ"]],
        ["set・フルブースト",["set・オールマイティ"]],
        ["set・オールアウト",["set・オールマイティ"]],
        ["アナライズver4"],
        ["set・オールマイティ"],
    ],


 "我流回復術": [
        ["ヒーリングソング",["キュアーララバイ"]],
       ["マギヒール",["クリア","マギヒーリング"]],
        ["チアフルソング",["キュアーララバイ"]],
        ["プリベンション",["マギカブロック","パワーシルト"]],
        ["キュアーララバイ",["チアー＆キュアー"]],

	["マギヒーリング",["クリアヒール","スタンドアップ"]],
        ["マギカブロック",["プリベンションエア"]],
        ["パワーシルト",["プリベンションエア"]],
        ["クリア",["クリアヒール"]],
        ["クリアヒール",["フルマギカヒール","スタンドアップ"]],

        ["スタンドアップ",["クリアレイン"]],
        ["フルマギカヒール",["クリアレイン","ホーリーララバイ"]],
        ["チアー＆キュアー",["ホーリーララバイ"]],
        ["プリベンションエア",["マギカシルトエア","パワーシルトエア"]],
        ["マギカシルトエア",["セントシルトエア"]],

        ["パワーシルトエア",["セントシルトエア"]],
        ["クリアレイン",["セイクリッドキュアー"]],
        ["ホーリーララバイ",["セイクリッドキュアー"]],
        ["セントシルトエア"],
        ["セイクリッドキュアー"],
    ],

 "魔導銃術": [
        ["マジックバレット",["フレイムバレット","アイスバレット","サンダーバレット","アースバレット","ウインドバレット","ウォーターバレット","マギスライド"]],
        ["スタンバレット",["トリプルスタン"]],
        ["フレイムバレット",["マギカレイルバレット"]],
        ["アイスバレット",["マギカレイルバレット"]],
        ["サンダーバレット",["マギカレイルバレット"]],

	["アースバレット",["マギカレイルバレット"]],
        ["ウインドバレット",["マギカレイルバレット"]],
        ["ウォーターバレット",["マギカレイルバレット"]],
        ["マギスライド",["セットポジション"]],
        ["トリプルスタン",["セットポジション"]],

        ["セットポジション",["ダークワン","シャイニングゼロ"]],
        ["マギカレイルバレット",["ブレイズショット","フリージングダブル","ライジングゼロ","クエイクブレイク","タイフーン","ヴォルテクス"]],
        ["ブレイズショット",["ダークワン","シャイニングゼロ"]],
        ["フリージングダブル",["ダークワン","シャイニングゼロ"]],
        ["ライジングゼロ",["ダークワン","シャイニングゼロ"]],

        ["クエイクブレイク",["ダークワン","シャイニングゼロ"]],
        ["タイフーン",["ダークワン","シャイニングゼロ"]],
        ["ヴォルテクス",["ダークワン","シャイニングゼロ"]],
        ["ダークワン"],
        ["シャイニングゼロ"],
    ],

"エルパッシブスキル": [
        ["初気練り", ["弐気練り"]],
	["弐気練り", ["参気練り"]],
        ["参気練り", ["龍気練り"]],
        ["龍気練り"],
        ["しっかりストレッチ", ["ばっちりストレッチ"]],
	["ばっちりストレッチ", ["しなっとストレッチ"]],
        ["しなっとストレッチ", ["かんぺきストレッチ"]],
        ["かんぺきストレッチ"],
        ["よく見る", ["じいっとよく見る"]],
	["じいっとよく見る", ["すごくよく見る"]],
        ["すごくよく見る", ["まじまじと見る"]],
        ["まじまじと見る"],
        ["赤角赤瞳1", ["赤角赤瞳2"]],
	["赤角赤瞳2", ["赤角赤瞳3"]],
        ["赤角赤瞳3", ["赤角赤瞳4"]],
	["赤角赤瞳4", ["赤角赤瞳5"]],
        ["赤角赤瞳5"],
        ["天賦の魔才1", ["天賦の魔才2"]],
	["天賦の魔才2", ["天賦の魔才3"]],
        ["天賦の魔才3", ["天賦の魔才4"]],
	["天賦の魔才4", ["天賦の魔才5"]],
        ["天賦の魔才5"],
   ],

"ラミルパッシブスキル": [
        ["天賦の魔導技巧1", ["天賦の魔導技巧2"]],
	["天賦の魔導技巧2", ["天賦の魔導技巧3"]],
        ["天賦の魔導技巧3", ["天賦の魔導技巧4"]],
	["天賦の魔導技巧4", ["天賦の魔導技巧5"]],
        ["天賦の魔導技巧5"],
        ["超開発術:お薬", ["超開発術:警戒"]],
	["超開発術:警戒", ["超開発術:先制"]],
        ["超開発術:先制", ["超開発術:お金"]],
	["超開発術:お金", ["超開発術:収集"]],
        ["超開発術:収集"],
        ["魔導相殺1", ["魔導相殺2"]],
	["魔導相殺2", ["魔導相殺3"]],
        ["魔導相殺3", ["魔導相殺4"]],
	["魔導相殺4", ["魔導相殺5"]],
        ["魔導相殺5"],
        ["ハイチューニング1", ["ハイチューニング2"]],
	["ハイチューニング2", ["ハイチューニング3"]],
        ["ハイチューニング3", ["ハイチューニング4"]],
	["ハイチューニング4", ["ハイチューニング5"]],
        ["ハイチューニング5"],
        ["超効率操作1", ["超効率操作2"]],
	["超効率操作2", ["超効率操作3"]],
        ["超効率操作3", ["超効率操作4"]],
	["超効率操作4", ["超効率操作5"]],
        ["超効率操作5"],
   ],

"リディシアパッシブスキル": [
        ["癒しの魔力1", ["癒しの魔力2"]],
	["癒しの魔力2", ["癒しの魔力3"]],
        ["癒しの魔力3", ["癒しの魔力4"]],
	["癒しの魔力4", ["癒しの魔力5"]],
        ["癒しの魔力5"],
        ["清めの力1", ["清めの力2"]],
	["清めの力2", ["清めの力3"]],
        ["清めの力3", ["清めの力4"]],
	["清めの力4", ["清めの力5"]],
        ["清めの力5"],
        ["護身専念1", ["護身専念2"]],
	["護身専念2", ["護身専念3"]],
        ["護身専念3", ["護身専念4"]],
	["護身専念4", ["護身専念5"]],
        ["護身専念5"],
        ["守護の纏い1", ["守護の纏い2"]],
	["守護の纏い2", ["守護の纏い3"]],
        ["守護の纏い3", ["守護の纏い4"]],
	["守護の纏い4", ["守護の纏い5"]],
        ["守護の纏い5"],
        ["揺るがずの肉体1", ["揺るがずの肉体2"]],
	["揺るがずの肉体2", ["揺るがずの肉体3"]],
        ["揺るがずの肉体3", ["揺るがずの肉体4"]],
	["揺るがずの肉体4", ["揺るがずの肉体5"]],
        ["揺るがずの肉体5"],
   ],

 "共通パッシブスキル": [
        ["HPアップ1", ["HPアップ2"]],
	["HPアップ2", ["HPアップ3"]],
        ["HPアップ3", ["HPアップ4"]],
	["HPアップ4", ["HPアップ5"]],
        ["HPアップ5"],
        ["MPアップ1", ["MPアップ2"]],
	["MPアップ2", ["MPアップ3"]],
        ["MPアップ3", ["MPアップ4"]],
	["MPアップ4", ["MPアップ5"]],
        ["MPアップ5"],
        ["攻撃力アップ1", ["攻撃力アップ2"]],
	["攻撃力アップ2", ["攻撃力アップ3"]],
        ["攻撃力アップ3", ["攻撃力アップ4"]],
	["攻撃力アップ4", ["攻撃力アップ5"]],
        ["攻撃力アップ5"],
        ["防御力アップ1", ["防御力アップ2"]],
	["防御力アップ2", ["防御力アップ3"]],
        ["防御力アップ3", ["防御力アップ4"]],
	["防御力アップ4", ["防御力アップ5"]],
        ["防御力アップ5"],
        ["魔法攻撃アップ1", ["魔法攻撃アップ2"]],
	["魔法攻撃アップ2", ["魔法攻撃アップ3"]],
        ["魔法攻撃アップ3", ["魔法攻撃アップ4"]],
	["魔法攻撃アップ4", ["魔法攻撃アップ5"]],
        ["魔法攻撃アップ5"],
        ["魔法防御アップ1", ["魔法防御アップ2"]],
	["魔法防御アップ2", ["魔法防御アップ3"]],
        ["魔法防御アップ3", ["魔法防御アップ4"]],
	["魔法防御アップ4", ["魔法防御アップ5"]],
        ["魔法防御アップ5"],
        ["敏捷アップ1", ["敏捷アップ2"]],
	["敏捷アップ2", ["敏捷アップ3"]],
        ["敏捷アップ3", ["敏捷アップ4"]],
	["敏捷アップ4", ["敏捷アップ5"]],
        ["敏捷アップ5"],
        ["運アップ1", ["運アップ2"]],
	["運アップ2", ["運アップ3"]],
        ["運アップ3", ["運アップ4"]],
	["運アップ4", ["運アップ5"]],
        ["運アップ5"],

    ],

    "下位攻撃魔法": [
        ["ファイアⅠ", ["ファイアⅡ", "フレイムⅠ"]],
        ["ファイアⅡ", ["ファイアⅢ", "フレイムⅡ"]],
        ["フレイムⅠ", ["フレイムⅡ"]],
        ["ファイアⅢ"],
        ["フレイムⅡ"],

        ["アイスⅠ", ["アイスⅡ", "ブリザードⅠ"]],
        ["アイスⅡ", ["アイスⅢ", "ブリザードⅡ"]],
        ["ブリザードⅠ", ["ブリザードⅡ"]],
        ["アイスⅢ"],
        ["ブリザードⅡ"],

        ["サンダーⅠ", ["サンダーⅡ", "スパークⅠ"]],
        ["サンダーⅡ", ["サンダーⅢ", "スパークⅡ"]],
        ["スパークⅠ", ["スパークⅡ"]],
        ["サンダーⅢ"],
        ["スパークⅡ"],
    ],

    "上位攻撃魔法": [
        ["ファイアⅠ", ["ファイアⅡ", "フレイムⅠ"]],
        ["ファイアⅡ", ["ファイアⅢ", "フレイムⅡ"]],
        ["フレイムⅠ", ["フレイムⅡ"]],
        ["ファイアⅢ", ["フレイムⅢ"]],
        ["フレイムⅡ", ["フレイムⅢ"]],
        ["フレイムⅢ", ["ニュークリアⅠ"]],

        ["アイスⅠ", ["アイスⅡ", "ブリザードⅠ"]],
        ["アイスⅡ", ["アイスⅢ", "ブリザードⅡ"]],
        ["ブリザードⅠ", ["ブリザードⅡ"]],
        ["アイスⅢ", ["ブリザードⅢ"]],
        ["ブリザードⅡ", ["ブリザードⅢ"]],
        ["ブリザードⅢ", ["ニュークリアⅠ"]],

        ["サンダーⅠ", ["サンダーⅡ", "スパークⅠ"]],
        ["サンダーⅡ", ["サンダーⅢ", "スパークⅡ"]],
        ["スパークⅠ", ["スパークⅡ"]],
        ["サンダーⅢ", ["スパークⅢ"]],
        ["スパークⅡ", ["スパークⅢ"]],
        ["スパークⅢ", ["ニュークリアⅠ"]],

        ["ニュークリアⅠ", ["ニュークリアⅡ"]],
        ["ニュークリアⅡ"],
    ],

    "回復魔法": [
        ["キュアーⅠ", ["キュアーⅡ"]],
        ["キュアーⅡ", ["キュアーⅢ"]],
        ["キュアーⅢ", ["レイズⅠ"]],

        ["ヒールⅠ", ["ヒールⅡ", "リカバーⅠ"]],
        ["ヒールⅡ", ["ヒールⅢ"]],
        ["リカバーⅠ", ["リカバーⅡ"]],
        ["ヒールⅢ", ["リカバーⅢ"]],
        ["リカバーⅡ", ["リカバーⅢ"]],

        ["レイズⅠ", ["レイズⅡ"]],
        ["リカバーⅢ", ["レイズⅡ"]],
        ["レイズⅡ"],
    ],

    "回復魔法2": [
        ["キュアーⅠ", ["キュアーⅡ"]],
        ["キュアーⅡ", ["キュアーⅢ"]],
        ["キュアーⅢ", ["レイズⅠ"]],

        ["ヒールⅠ", ["ヒールⅡ", "リカバーⅠ"]],
        ["ヒールⅡ", ["ヒールⅢ"]],
        ["リカバーⅠ", ["リカバーⅡ"]],
        ["ヒールⅢ", ["リカバーⅢ"]],
        ["リカバーⅡ", ["リカバーⅢ"]],

        ["レイズⅠ", ["レイズⅡ"]],
        ["リカバーⅢ", ["レイズⅡ"]],
        ["レイズⅡ"],
    ],
},

// レベルアップによってSPを獲得する場合、レベルごとに得られるSP値を以下の形式で設定します。
// classId: 職業ID, default: デフォルト値, レベル: SP値, レベル: SP値, ...
// 下記の設定例では、レベル2では3SP取得、レベル3では4SP取得、それ以外のレベルでは5SPを獲得します。
levelUpGainSp: [
    {
        classId: 1,
        default: 0,
        2: 0,
        3: 0,
    },

    {
        classId: 2,
        default: 5,
        2: 3,
        3: 4,
    },

    {
        classId: 3,
        default: 5,
        2: 3,
        3: 4,
    },

 // {
       // classId: 4,
     //   default: 5,
   //     2: 3,
 //       3: 4,
//    },

    {
        classId: 5,
        default: 5,
        2: 3,
        3: 4,
    },

    {
        classId: 6,
        default: 5,
        2: 3,
        3: 4,
    },

    {
        classId: 7,
        default: 5,
        2: 3,
        3: 4,
    },

    {
        classId: 8,
        default: 5,
        2: 3,
        3: 4,
    },
{
        classId: 9,
        default: 1,
       
    },
{
        classId: 10,
        default: 1,
       
    },
{
        classId:11,
        default: 1,
       
    },
]
// =============================================================
// ●設定項目はここまでです。
// =============================================================
};
};
